%define _unpackaged_files_terminate_build 1
%define pypi_name GitPython

%def_with check

Name: python3-module-%pypi_name
Version: 3.1.44
Release: alt1.1
Summary: GitPython is a python library used to interact with Git repositories
License: BSD
Group: Development/Python3
Url: https://pypi.org/project/GitPython/
VCS: https://github.com/gitpython-developers/GitPython
BuildArch: noarch
Source: %name-%version.tar
Source1: git-history-tests.tar
Source2: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
Requires: /usr/bin/git
# PyPI names
Provides: python3-module-gitpython = %EVR
%py3_provides GitPython
%py3_provides gitpython
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
BuildRequires: /proc
BuildRequires: /usr/bin/git
BuildRequires: /usr/sbin/git-daemon
# not packaged and seems unmaintained
%pyproject_builddeps_metadata
%pyproject_builddeps_check
BuildRequires: python3-module-gitdb-tests
%endif

%description
%pypi_name is a python library used to interact with git repositories,
high-level like git-porcelain, or low-level like git-plumbing.

It provides abstractions of git objects for easy access of repository data, and
additionally allows you to access the git repository more directly using either
a pure python implementation, or the faster, but more resource intensive git
command implementation.

The object database implementation is optimized for handling large quantities of
objects and large datasets, which is achieved by using low-level structures and
data streaming.

%prep
%setup -a 1
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile test-requirements.txt
%endif

# unbundle
rm -vr git/ext/*

%build
%pyproject_build

%install
%pyproject_install

%check
# Tests expect project's own git repo + submodules
export GIT_CONFIG_GLOBAL=~/.gitconfig
cat test/fixtures/.gitconfig > "$GIT_CONFIG_GLOBAL"
git config --global user.email "someone@somewhere.com"
git config --global user.name "someone"

# prepare test git repo
TEST_REPO="$(pwd)/test_repo"
rm -rf "$TEST_REPO"
mkdir "$TEST_REPO"
cp -a .git "$TEST_REPO"/
pushd "$TEST_REPO"
# see .github/workflows/pythonpackage.yml
TRAVIS=yes ../init-tests-after-clone.sh
popd
export GIT_PYTHON_TEST_GIT_REPO_BASE="$TEST_REPO"

# /usr/sbin/git-daemon
export PATH=$PATH:%_sbindir
export NO_SUBMODULES=YES
%pyproject_run_pytest \
    -vra \
    -o=addopts='' \
    --ignore test/test_installation.py \
    --ignore test/test_submodule.py

%files
%python3_sitelibdir/git/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
