%define  oname PyGithub

%def_with check

Name:    python3-module-%oname
Version: 2.8.1
Release: alt1

Summary: Typed interactions with the GitHub API v3
License: LGPL-3.0
Group:   Development/Python3
URL:     https://github.com/PyGithub/PyGithub

Packager: Grigory Ustinov <grenka@altlinux.org>

BuildRequires(pre): rpm-build-python3

Buildrequires: python3-module-setuptools
Buildrequires: python3-module-setuptools_scm
Buildrequires: python3-module-wheel

%if_with check
Buildrequires: python3-module-requests
Buildrequires: python3-module-deprecated
Buildrequires: python3-module-pynacl
Buildrequires: python3-module-jwt
Buildrequires: python3-module-pytest-cov
Buildrequires: python3-module-dateutil
Buildrequires: python3-module-typing-extensions
Buildrequires: python3-module-cryptography
Buildrequires: python3-module-responses
%endif

BuildArch: noarch

Source:  %name-%version.tar

# mapping from PyPI name
# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-%{pep503_name %oname} = %EVR

%description
PyGitHub is a Python library to access the GitHub REST API. This library enables
you to manage GitHub resources such as repositories, user profiles,
and organizations in your Python applications.

%prep
%setup

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_install

%check
%tox_check_pyproject

%files
%doc COPYING *.md
%python3_sitelibdir/github
%python3_sitelibdir/%{pyproject_distinfo %oname}/

%changelog
