%define modulename acme

Name: python3-module-acme
Version: 2.10.0
Release: alt1

Summary: Python library for the ACME protocol

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.python.org/pypi/acme

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://pypi.io/packages/source/a/%modulename/%modulename-%version.tar.gz
Source: %modulename-%version.tar

BuildRequires(pre): rpm-build-python3 rpm-build-intro

# generated by 'epm restore --dry-run' from acme/setup.py install_requires
%py3_use cryptography >= 3.2.1
%py3_use josepy >= 1.13.0
%py3_use OpenSSL >= 17.5.0
%py3_use OpenSSL >= 23.1.0
%py3_use pyrfc3339
%py3_use pytz >= 2019.3
%py3_use requests >= 2.20.0

BuildArch: noarch

%description
Python libraries implementing the Automatic Certificate Management Environment
(ACME) protocol. It is used by the Certbot Project.

%package doc
Group: Development/Documentation
Summary: Documentation for python-acme libraries

%description doc
Documentation for the ACME python libraries

%prep
%setup -n %modulename-%version

%build
%python3_build

%install
%python3_install
#  it is better do not to require argparse on python >= 2.7.
%__subst "s|^argparse$||" \
    %buildroot%python3_sitelibdir/%modulename-%{version}*.egg-info/requires.txt
%python3_prune

%check
#__python setup.py test
#if_with python3
#__python3 setup.py test
#endif

%files
%doc LICENSE.txt
%python3_sitelibdir/%modulename/
%python3_sitelibdir/%modulename-%{version}*.egg-info

#%files doc
#%doc LICENSE.txt
#%doc README.rst
#%doc docs/_build/html

%changelog
