%define oname aiopg

%def_without docs
# tests need running Postgres server
%def_without check

Name: python3-module-%oname
Version: 1.4.0
Release: alt1.1

Summary: aiopg is a library for accessing a PostgreSQL database from the asyncio

License: BSD-2-Clause
Group: Development/Python3
Url: https://pypi.python.org/pypi/aiopg/

BuildArch: noarch

# https://github.com/aio-libs/aiopg.git
Source: %name-%version.tar
Patch1: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-psycopg2
BuildRequires: python3-module-async-timeout

BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx-devel python3-module-sphinxcontrib-asyncio
BuildRequires: python3-module-sqlalchemy
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%py3_provides %oname
%py3_requires asyncio psycopg2 sqlalchemy

%description
aiopg is a library for accessing a PostgreSQL database from the asyncio
(PEP-3156/tulip) framework. It wraps asynchronous features of the
Psycopg database driver.

%prep
%setup
%patch1 -p1

%if_with docs
%prepare_sphinx3 .
ln -s ../objects.inv docs/
%endif

%build
%pyproject_build

%install
%pyproject_install

%if_with docs
%make -C docs html SPHINXBUILD=sphinx-build-3
%endif

rm -f requirements.txt

%check
%tox_create_default_config
%tox_check_pyproject

%files
%doc LICENSE *.txt *.rst examples
%if_with docs
%doc docs/_build/html
%endif
%python3_sitelibdir/*

%changelog
