%define _unpackaged_files_terminate_build 1
%define pname bitcoin
%define oname python-bitcoinlib

%def_disable check

Name: python3-module-bitcoinlib
Version: 0.11.0
Release: alt1

Summary: Provides an easy interface to the Bitcoin data structures and protocol

License: LGPLv3+
Group: Development/Python3
Url: https://pypi.python.org/pypi/python-bitcoinlib/

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3-module-pytest
%endif

Provides: python3-module-%pname = %EVR

%py3_provides %pname
%py3_requires json


%description
This Python library provides an easy interface to the bitcoin data
structures and protocol. The approach is low-level and "ground up", with
a focus on providing tools to manipulate the internals of how Bitcoin
works.

%prep
%setup

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%python3_build

%install
%python3_install
%python3_prune

%check
python3 setup.py test

%files
%doc *.md PKG-INFO
%python3_sitelibdir/*


%changelog
