%define oname codepy

%def_with check

Name: python3-module-%oname
Version: 2019.1
Release: alt1

Summary: C metaprogramming toolkit for Python
License: MIT
Group: Development/Python3
Url: https://documen.tician.de/codepy/

VCS: https://github.com/inducer/codepy

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytools
BuildRequires: gcc-c++
BuildRequires: python3-module-appdirs
%endif

Requires: gcc-c++
Requires: python3-module-appdirs

%description
CodePy is a C metaprogramming toolkit for Python. It handles two aspects
of metaprogramming:

* Generating C source code.

* Compiling this source code and dynamically loading it into the Python
interpreter.

Both capabilities are meant to be used together, but also work on their
own. In particular, the code generation facilities work well in
conjunction with PyCuda. Dynamic compilation and linking are so far only
supported in Linux with the GNU toolchain.

%prep
%setup

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%python3_build_debug

%install
%python3_install

%check
export PYTHONPATH=$PWD
py.test-3

%files
%doc *.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version-*.egg-info


%changelog
