%define oname colorama

%def_with check

Name: python3-module-%oname
Version: 0.4.6
Release: alt1

Summary: Simple cross-platform colored terminal text in Python

License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.python.org/pypi/colorama

# https://github.com/tartley/colorama
Source0: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-hatchling

%if_with check
BuildRequires: python3-module-pytest
%endif

%py3_provides %oname

%description
Makes ANSI escape character sequences for producing colored terminal
text and cursor positioning work under MS Windows.

ANSI escape character sequences have long been used to produce colored
terminal text and cursor positioning on Unix and Macs. Colorama makes
this work on Windows, too, by wrapping stdout, stripping ANSI sequences
it finds (which otherwise show up as gobbledygook in your output), and
converting them into the appropriate win32 calls to modify the state of
the terminal. On other platforms, Colorama does nothing.

Colorama also provides some shortcuts to help generate ANSI sequences
but works fine in conjunction with any other ANSI sequence generation
library, such as Termcolor.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
py.test-3

%files
%doc *.rst demos
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
