%define oname cups

Name:          python3-module-cups
Version:       1.9.74
Release:       alt3.1

Summary:       Python bindings for the CUPS API

Group:         Development/Python3
Url:           http://cyberelk.net/tim/software/pycups/
License:       %gpl2plus

# git://git.fedorahosted.org/git/pycups.git
Source0:       pycups-%{version}.tar
Patch0:        python-module-cups-1.9.74-alt-extension-copy-document.patch
Patch1:        3df8a811b650c01cca595fff89209087b92f801c.patch

Packager:      Yury Yurevich <anarresti@altlinux.org>

BuildRequires(pre): rpm-build-licenses
BuildRequires(pre): libcups-devel >= 2.2.12-alt2

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-setuptools

%description
Python bindings for the CUPS API. This module allows
use the CUPS API (managing printers, jobs, etc) in Python.

%package docs
Summary: Documentation for Python bindings for the CUPS API
Group: Development/Documentation
BuildArch: noarch

%description docs
Python bindings for the CUPS API. This module allows
use the CUPS API (managing printers, jobs, etc) in Python.

This package contains documentation for Python bindings for the CUPS
API.

#--------------------------------------------------------------------

%prep
%setup -n pycups-%version
%patch0 -p1
%patch1 -p1

subst 's|python|python3|g' Makefile
subst 's|build/lib\*/$@|build/lib*/cups*.so|g' Makefile
subst 's|#!.*python$|#!%__python3|' $(grep -Rl 'python$' *)

%build
%make
%make doc

%install
%makeinstall_std

%files
%doc NEWS README TODO test.py examples
%python3_sitelibdir/*

%files docs
%doc html/*


%changelog
