%define oname cvxopt

%def_with check
%def_with docs

Name: python3-module-%oname
Version: 1.3.2
Release: alt1

Summary: Python Software for Convex Optimization

License: GPL-3.0-or-later
Group: Development/Python3
Url: http://cvxopt.org

Source: %oname-%version.tar.gz

BuildRequires(pre): rpm-build-python3
BuildRequires: dvipng libfftw3-devel libglpk-devel libgsl-devel liblapack-devel
BuildRequires: libblas-devel libsuitesparse-devel

%if_with docs
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-sphinx_rtd_theme
%endif

%if_with check
BuildRequires: python3-module-pytest
%endif

# mosek is not packaged and there is no tarball on pypi for it
%add_python3_req_skip mosekarr pymosek mosek mosek.array

Conflicts: %name-pickles < %version-%release

%description
CVXOPT is a free software package for convex optimization based on the
Python programming language. It can be used with the interactive Python
interpreter, on the command line by executing Python scripts, or
integrated in other software via Python extension modules. Its main
purpose is to make the development of software for convex optimization
applications straightforward by building on Python's extensive standard
library and on the strengths of Python as a high-level programming
language.

%package doc
Summary: Documentation for CVXOPT
Group: Documentation
BuildArch: noarch

%description doc
CVXOPT is a free software package for convex optimization based on the
Python programming language. It can be used with the interactive Python
interpreter, on the command line by executing Python scripts, or
integrated in other software via Python extension modules. Its main
purpose is to make the development of software for convex optimization
applications straightforward by building on Python's extensive standard
library and on the strengths of Python as a high-level programming
language.

This package contains documentation for CVXOPT.

%package examples
Summary: Examples for CVXOPT
Group: Documentation
BuildArch: noarch

%description examples
CVXOPT is a free software package for convex optimization based on the
Python programming language. It can be used with the interactive Python
interpreter, on the command line by executing Python scripts, or
integrated in other software via Python extension modules. Its main
purpose is to make the development of software for convex optimization
applications straightforward by building on Python's extensive standard
library and on the strengths of Python as a high-level programming
language.

This package contains examples for CVXOPT.

%package pickles
Summary: Pickles for CVXOPT
Group: Development/Python3

%description pickles
CVXOPT is a free software package for convex optimization based on the
Python programming language. It can be used with the interactive Python
interpreter, on the command line by executing Python scripts, or
integrated in other software via Python extension modules. Its main
purpose is to make the development of software for convex optimization
applications straightforward by building on Python's extensive standard
library and on the strengths of Python as a high-level programming
language.

This package contains pickles for CVXOPT.

%prep
%setup
sed -i 's,^BUILD_DSDP.\+$,BUILD_DSDP = 0,' setup.py

%ifarch %e2k
# openblas not available
sed -i 's,openblas,blas,g' setup.py
%endif

%if_with docs
%prepare_sphinx3 doc/source
%endif

%build
%if "%_lib" != "lib64"
sed -i 's|lib64|lib|g' setup.py
%endif
%if "%_arch" != "x86_64"
sed -i 's|x86_64|%_arch|g' setup.py
%endif
%add_optflags -fno-strict-aliasing
export CC="gcc"
export LDSHARED="gcc -shared $RPM_LD_FLAGS"
%python3_build_debug

%if_with docs
%make SPHINXBUILD="sphinx-build-3" -C doc html
%make SPHINXBUILD="sphinx-build-3" -C doc pickle
%endif

%install
%python3_install

%if_with docs
install -d %buildroot%_docdir/%name
cp -fR doc/build/html examples %buildroot%_docdir/%name/

cp -fR doc/build/pickle %buildroot%python3_sitelibdir/%oname/
%endif

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
%__python3 -m pytest

%files
%doc LICENSE README.md
%python3_sitelibdir/%oname
%python3_sitelibdir/*.egg-info
%if_with docs
%exclude %python3_sitelibdir/%oname/pickle

%files examples
%doc %dir %_docdir/%name
%doc %_docdir/%name/examples

%files doc
%doc %dir %_docdir/%name
%doc %_docdir/%name/html

%files pickles
%dir %python3_sitelibdir/%oname
%python3_sitelibdir/%oname/pickle
%endif

%changelog
