%define oname encore

%def_without docs

%def_with check

Name: python3-module-%oname
Version: 0.8.0
Release: alt2.1

Summary: A Collection of core-level utility modules for Enthought projects
License: BSD-3-Clause and Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/encore

VCS: https://github.com/enthought/encore
Source: %name-%version.tar
Patch: encore-0.8.0-unittest-alt-fix.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with docs
BuildRequires: python3-module-sphinx
%endif

%if_with check
BuildRequires: python3-modules-sqlite3
BuildRequires: python3-module-requests
BuildRequires: python3-module-pytest
%endif

%description
This package consists of a collection of core utility packages useful for
building Python applications.  This package is intended to be at the
bottom of the software stack and have zero required external dependencies
aside from the Python Standard Library.

%package docs
Summary: Documentation for encore
Group: Development/Documentation

%description docs
This package consists of a collection of core utility packages useful for
building Python applications.  This package is intended to be at the
bottom of the software stack and have zero required external dependencies
aside from the Python Standard Library.

This package contains documentation for encore.

%package tests
Summary: Tests for encore
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package consists of a collection of core utility packages useful for
building Python applications.  This package is intended to be at the
bottom of the software stack and have zero required external dependencies
aside from the Python Standard Library.

This package contains tests for encore.

%prep
%setup
%patch -p1

sed -i 's|sphinx-build|sphinx-build-3|' docs/Makefile

%build
%pyproject_build

%install
%pyproject_install

%if_with docs
export PYTHONPATH=%buildroot%python3_sitelibdir
%make -C docs html

cp -fR docs/build/pickle %buildroot%python3_sitelibdir/%oname/
%endif

%check
%pyproject_run_pytest -v

%files
%doc LICENSE.txt README.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}
%exclude %python3_sitelibdir/*/testing
%exclude %python3_sitelibdir/*/*/tests
%exclude %python3_sitelibdir/*/*/*/tests

%if_with docs
%files docs
%doc docs/build/html/*
%endif

%files tests
%python3_sitelibdir/*/testing
%python3_sitelibdir/*/*/tests
%python3_sitelibdir/*/*/*/tests


%changelog
