Name: python3-module-ephem
Version: 4.1.5
Release: alt1

Summary: Compute positions of the planets and stars
License: LGPL-3
Group: Development/Python
Url: https://pypi.python.org/pypi/ephem/

Source: %name-%version-%release.tar

BuildRequires: rpm-build-python3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%description
PyEphem provides an ephem Python package for performing high-precision
astronomy computations. The underlying numeric routines are coded in C
and are the same ones that drive the popular XEphem astronomy
application, whose author, Elwood Charles Downey, generously gave
permission for their use in PyEphem. The name ephem is short for the
word ephemeris, which is the traditional term for a table giving the
position of a planet, asteroid, or comet for a series of dates.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%files
%doc *.rst ephem/doc/*.rst issues
%python3_sitelibdir/ephem
%python3_sitelibdir/ephem-%version.dist-info
%exclude %python3_sitelibdir/ephem/doc
%exclude %python3_sitelibdir/ephem/tests

%changelog
