%define oname fabio

# [armh]
# [00:01:02]   File "/usr/src/RPM/BUILD/python3-module-fabio-2023.6/build/lib/python3/site-packages/fabio/test/codecs/test_brukerimage.py", line 155, in test_linear
# [00:01:02]     self.assertTrue(error < numpy.finfo(numpy.float32).eps, "Error is %s>1e-7" % error)
# [00:01:02] AssertionError: False is not true : Error is 1.1920929e-07>1e-7
%ifnarch armh
%def_with check
%else
%def_without check
%endif

Name: python3-module-%oname
Version: 2024.4
Release: alt1

Summary: Image IO for fable

License: BSD-3-Clause AND GPL-2.0-or-later AND LGPL-3.0-or-later AND MIT
Group: Development/Python3
URL: https://pypi.org/project/fabio
VCS: https://github.com/silx-kit/fabio

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: libnumpy-py3-devel
BuildRequires: python3-module-Cython
BuildRequires: meson
BuildRequires: python3-module-mesonpy

%if_with check
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-h5py
BuildRequires: python3-module-Pillow
BuildRequires: python3-module-glymur
%endif

%description
FabIO is an I/O library for images produced by 2D X-ray detectors and written
in Python. FabIO support images detectors from a dozen of companies
(including Mar, Dectris, ADSC, Hamamatsu, Oxford), for a total of 30 different
file formats (like CBF, EDF, TIFF) and offers an unified interface to their
headers (as a Python dictionary) and datasets (as a numpy ndarray of integers or
floats)

%prep
%setup

# Hotfix for 2024.4 unmet dependency python3(fabio._version)
sed -i "s/\.\._version/\.\.version/" \
    src/fabio/app/eiger2crysalis.py src/fabio/app/densify.py

# remove some third-party bundled stuff
rm -rv src/fabio/third_party/_local

%build
%pyproject_build

%install
%pyproject_install

%check
env PYTHONPATH=%buildroot%python3_sitelibdir \
python3 run_tests.py --installed

%files
%doc copyright *.rst
%_bindir/densify_Bragg
%_bindir/eiger2cbf
%_bindir/eiger2crysalis
%_bindir/fabio-convert
%_bindir/fabio_viewer
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.0.dist-info
%exclude %python3_sitelibdir/%oname/test/*
%exclude %python3_sitelibdir/%oname/benchmark/*

%changelog
