%define oname fiona

# check relies on a lot of network
%def_without check

Name: python3-module-%oname
Version: 1.10.1
Release: alt1

Summary: Fiona reads and writes spatial data files

License: BSD-3-Clause
Group: Development/Python3
URL: https://pypi.org/project/fiona
VCS: https://github.com/Toblerity/Fiona

Source: %name-%version.tar

Patch: use_sphinx-apidoc-3.patch

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: libgdal-devel gcc-c++
BuildRequires: python3-module-Cython
BuildRequires: python3-module-attrs
BuildRequires: python3-module-click
BuildRequires: python3-module-cligj
BuildRequires: python3-module-munch

Conflicts: fio
Conflicts: python-module-fiona < %EVR
Obsoletes: python-module-fiona < %EVR
%py3_provides %oname

%description
Fiona is OGR's neat, nimble, no-nonsense API for Python programmers.

Fiona is designed to be simple and dependable. It focuses on reading and
writing data in standard Python IO style and relies upon familiar Python
types and protocols such as files, dictionaries, mappings, and iterators
instead of classes specific to OGR. Fiona can read and write real-world
data using multi-layered GIS formats and zipped virtual file systems and
integrates readily with other Python GIS packages such as pyproj, Rtree,
and Shapely.

%prep
%setup
%patch -p1

%build
%add_optflags -fno-strict-aliasing
%python3_build

%install
%python3_install

%check

%files
%doc CHANGES.txt CREDITS.txt *.rst examples
%_bindir/fio
%python3_sitelibdir/%oname
%python3_sitelibdir/fiona-%version-py%_python3_version.egg-info

%changelog
