%define _unpackaged_files_terminate_build 1
%define oname future

%def_with check

Name: python3-module-%oname
Version: 1.0.0
Release: alt1.1
Summary: Clean single-source support for Python 3 and 2
License: MIT
Group: Development/Python3
Url: https://python-future.org/

# https://github.com/PythonCharmers/python-future.git
Source: %name-%version.tar
Patch0: %name-%version-alt.patch
Patch1: %oname-%version-skip_tests_with_connection_errors.patch
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
BuildRequires: python3(pytest)
BuildRequires: python3(tox_console_scripts)
BuildRequires: python3(tox_no_deps)
BuildRequires: python3(tox)
%endif

# filter requires of self
%filter_from_requires /python3\(\.[[:digit:]]\)\?(future\..*)/d

%description
future is the missing compatibility layer between Python 3 and Python 2.
It allows you to use a single, clean Python 3.x-compatible codebase to
support both Python 3 and Python 2 with minimal overhead.

%prep
%setup
%autopatch -p1

%build
%pyproject_build

%install
%pyproject_install

# don't package tests
rm -rv %buildroot%python3_sitelibdir/*/*/test
rm -rv %buildroot%python3_sitelibdir/*/tests

rm -rv %buildroot%_bindir/*

%check
%tox_create_default_config
%tox_check_pyproject -- -k 'not test_isinstance_recursion_limit and not test_subclass_recursion_limit and not test_main and not test_ftp'

%files
%doc *.txt *.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/libfuturize
%python3_sitelibdir/libpasteurize
%python3_sitelibdir/past
%python3_sitelibdir/%oname-%version.dist-info

%changelog
