%define oname greenlet

%def_with check

Name: python3-module-%oname
Version: 3.1.1
Release: alt1

Summary: Lightweight in-process concurrent programming

License: MIT
Group: Development/Python3
URL: https://pypi.org/project/greenlet
VCS: https://github.com/python-greenlet/greenlet

Source: %name-%version.tar

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-psutil
BuildRequires: python3-module-objgraph
BuildRequires: /proc
%endif

%description
The greenlet package is a spin-off of Stackless, a version of CPython
that supports micro-threads called "tasklets". Tasklets run
pseudo-concurrently (typically in a single or a few OS-level threads)
and are synchronized with data exchanges on "channels".

A "greenlet", on the other hand, is a still more primitive notion of
micro- thread with no implicit scheduling; coroutines, in other words.
This is useful when you want to control exactly when your code runs. You
can build custom scheduled micro-threads on top of greenlet; however, it
seems that greenlets are useful on their own as a way to make advanced
control flow structures. For example, we can recreate generators; the
difference with Python's own generators is that our generators can call
nested functions and the nested functions can yield values too.
Additionally, you don't need a "yield" keyword. See the example in
tests/test_generator.py.

Greenlets are provided as a C extension module for the regular
unmodified interpreter.

%package devel
Summary: C development headers for %name
Group:   Development/C
Requires: %name = %EVR

%description devel
%summary.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
cd /
PYTHONPATH="%buildroot%python3_sitelibdir" \
  python3 -m unittest discover -v \
  -s "%buildroot%python3_sitelibdir/greenlet/tests" \
  -t "%buildroot%python3_sitelibdir"

%files
%doc AUTHORS CHANGES.rst LICENSE* README*
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%files devel
%doc AUTHORS CHANGES.rst LICENSE* README*
%_includedir/python%_python3_version%_python3_abiflags/greenlet

%changelog
