%define  modulename httpcore

Name:    python3-module-%modulename
Version: 1.0.5
Release: alt1

Summary: A minimal HTTP client

License: BSD-3-Clause
Group:   Development/Python3
URL:     https://www.encode.io/httpcore/

# Source-url: https://github.com/encode/httpcore/archive/%version.tar.gz
Source:  %modulename-%version.tar

BuildRequires(pre): rpm-build-pyproject
BuildRequires: python3(hatchling)
BuildRequires: python3(hatch-fancy-pypi-readme)

BuildArch: noarch

%description
The HTTP Core package provides a minimal low-level HTTP client,
which does one thing only. Sending HTTP requests.

It does not provide any high level model abstractions over the API,
does not handle redirects, multipart uploads, building authentication headers,
transparent HTTP caching, URL parsing, session cookie handling,
content or charset decoding, handling JSON,
environment based configuration defaults, or any of that Jazz.

Some things HTTP Core does do:

* Sending HTTP requests.
* Provides both sync and async interfaces.
* Supports HTTP/1.1 and HTTP/2.
* Async backend support for asyncio and trio.
* Automatic connection pooling.
* HTTP(S) proxy support.

%prep
%setup -n %modulename-%version

%build
%pyproject_build

%install
%pyproject_install

# asyncio alternatives, optional
%add_python3_req_skip anyio sockio trio
%add_python3_req_skip h2.config h2.connection h2.events h2.exceptions h2.settings

%files
%python3_sitelibdir/%modulename
%python3_sitelibdir/*.dist-info

%changelog
