%define _unpackaged_files_terminate_build 1
%global pypi_name iso8601

%def_with check

Name: python3-module-%pypi_name
Version: 0.1.16
Release: alt2
Summary: Simple module to parse ISO 8601 dates

Group: Development/Python3
License: MIT
Url: https://pypi.org/project/iso8601/
Source0: %name-%version.tar

BuildRequires: rpm-build-python3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
BuildRequires: python3(pytest)
BuildRequires: python3(tox)
BuildRequires: python3(tox_no_deps)
BuildRequires: python3(tox_console_scripts)
%endif

BuildArch: noarch

%description
This module parses the most common forms of ISO 8601 date strings (e.g.
2007-01-14T20:34:22+00:00) into datetime objects.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_check_pyproject

%files
%doc LICENSE README.rst
%python3_sitelibdir/%pypi_name/
%python3_sitelibdir/%pypi_name-%version.dist-info/
%exclude %python3_sitelibdir/%pypi_name/test_iso8601.py
%exclude %python3_sitelibdir/%pypi_name/__pycache__/test_iso8601.cpython*

%changelog
