%define pypi_name jsonschema

%def_with check

Name: python3-module-%pypi_name
Version: 4.25.1
Release: alt1

Summary: An implementation of JSON Schema validation for Python

License: MIT
Group: Development/Python3
URL: https://pypi.org/project/jsonschema
VCS: https://github.com/python-jsonschema/jsonschema
BuildArch: noarch
Source0: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-hatchling
BuildRequires: python3-module-hatch-fancy-pypi-readme
BuildRequires: python3-module-hatch-vcs
%if_with check
BuildRequires: python3-module-attrs
BuildRequires: python3-module-jsonschema-specifications
BuildRequires: python3-module-referencing
BuildRequires: python3-module-rpds-py
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pip
BuildRequires: python3-module-jsonpath-ng
%endif

# https://bugzilla.altlinux.org/38673
Conflicts: python-module-jsonschema < 2.6.0-alt3

%description
jsonschema is an implementation of the JSON Schema specification for Python.

%prep
%setup

%build
if [ ! -d .git ]; then
    git init
    git config user.email Julian@GrayVines.com
    git config user.name Julian Berman
    git add .
    git commit -m 'release'
    git tag '%version'
fi
%pyproject_build

%install
%pyproject_install
rm -rfv %buildroot%python3_sitelibdir/%pypi_name/benchmarks/
rm -rfv %buildroot%python3_sitelibdir/%pypi_name/tests/

%check
export JSON_SCHEMA_TEST_SUITE=$PWD/json
%pyproject_run_pytest -v jsonschema

%files
%doc *.rst COPYING
%_bindir/%pypi_name
%python3_sitelibdir/%pypi_name
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}

%changelog
