%define _unpackaged_files_terminate_build 1

%define oname jupyter_core

%def_with check

Name: python3-module-%oname
Version: 5.7.2
Release: alt1
Summary: Jupyter core package
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.org/project/jupyter-core
Vcs: https://github.com/jupyter/jupyter_core.git
BuildArch: noarch
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-hatchling
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-platformdirs
BuildRequires: python3-module-traitlets
BuildRequires: python3-module-pip
%endif

%description
Jupyter core package. A base package on which Jupyter projects rely.

%prep
%setup
sed -i "/addopts/,/]/ s/--color=yes//" pyproject.toml

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -v \
	--deselect "jupyter_core/paths.py::jupyter_core.paths.jupyter_path" \
	--deselect "tests/test_paths.py::test_jupyter_path" \
	--deselect "tests/test_paths.py::test_jupyter_path_user_site" \
	--deselect "tests/test_paths.py::test_jupyter_path_no_user_site" \
	--deselect "tests/test_paths.py::test_jupyter_config_path" \
	--deselect "tests/test_paths.py::test_jupyter_config_path_no_user_site"

%files
%doc *.md
%_bindir/*
%python3_sitelibdir/jupyter.py
%python3_sitelibdir/__pycache__/jupyter.*
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
