%define oname latexcodec

%def_with check
%def_with docs

Name: python3-module-%oname
Version: 3.0.0
Release: alt1

Summary: A lexer and codec to work with LaTeX code in Python
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/latexcodec
Vcs: https://github.com/mcmtroffaes/latexcodec.git
BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with docs
BuildRequires: python3-module-sphinx
%endif

%if_with check
BuildRequires: python3-module-pytest
%endif

%py3_provides %oname

%description
A lexer and codec to work with LaTeX code in Python.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
A lexer and codec to work with LaTeX code in Python.

This package contains pickles for %oname.

%prep
%setup

sed -i 's|sphinx-build|sphinx-build-3|' doc/Makefile

%build
%pyproject_build

%install
%pyproject_install

%if_with docs
export PYTHONPATH=$PWD
%make -C doc pickle
%make -C doc html
cp -fR doc/_build/pickle %buildroot%python3_sitelibdir/%oname/
%endif

%check
%pyproject_run_pytest -v

%files
%doc README.*
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}
%if_with docs
%doc doc/_build/html
%exclude %python3_sitelibdir/%oname/pickle

%files pickles
%dir %python3_sitelibdir/%oname/
%python3_sitelibdir/%oname/pickle
%endif


%changelog
