%define _unpackaged_files_terminate_build 1

%define oname lazr.restfulclient

%def_with check

Name: python3-module-%oname
Version: 0.14.6
Release: alt1.1

Summary: A programmable lazr.restful client library

License: LGPLv3
Group: Development/Python3
Url: https://launchpad.net/lazr.restfulclient

BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-fixtures
BuildRequires: python3-module-wsgi_intercept
BuildRequires: python3-module-httplib2
BuildRequires: python3-module-oauthlib
BuildRequires: python3-module-wadllib
BuildRequires: python3-module-distro
BuildRequires: python3-module-zope.testrunner
%endif

%py3_provides lazr.restfulclient

%description
A programmable client library that takes advantage of the commonalities
among lazr.restful web services to provide added functionality on top of wadllib.

This project is also part of https://launchpad.net/lazr.

%package tests
Summary: lazr.restfulclient tests
Group: Development/Python3
Requires: %name = %version-%release

%description tests
%summary

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
rm -rf src/lazr/restfulclient/tests/test_docs.py
%pyproject_run -- zope-testrunner --test-path=src -vc

%files
%doc *.rst
%python3_sitelibdir/lazr/restfulclient
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%python3_sitelibdir/%oname-%version-py%_python3_version-nspkg.pth
%exclude %python3_sitelibdir/lazr/restfulclient/tests

%files tests
%python3_sitelibdir/lazr/restfulclient/tests

%changelog
