%define _unpackaged_files_terminate_build 1
%define pypi_name libcst
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 1.7.0
Release: alt1

Summary: A Concrete Syntax Tree (CST) parser and serializer library for Python
License: MIT and Python-2.0 and Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/libcst/
Vcs: https://github.com/Instagram/LibCST
Source0: %name-%version.tar
Source1: vendor_rust.tar
Source2: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter fixit
%add_pyproject_deps_check_filter hypothesmith
%add_pyproject_deps_check_filter prompt-toolkit
%add_pyproject_deps_check_filter pyre-check
%add_pyproject_deps_check_filter slotscheck
%pyproject_builddeps_metadata_extra dev-without-jupyter
%pyproject_builddeps_check
%endif
# rust stuff
BuildRequires: /proc
BuildRequires: rust
BuildRequires: rust-cargo

%description
LibCST parses Python source code as a CST tree that keeps all formatting
details (comments, whitespaces, parentheses, etc). It's useful for building
automated refactoring (codemod) applications and linters.

LibCST creates a compromise between an Abstract Syntax Tree (AST) and a
traditional Concrete Syntax Tree (CST). By carefully reorganizing and naming
node types and fields, we've created a lossless CST that looks and feels like
an AST.

%prep
%setup -a1
%autopatch -p1
echo >> .cargo/config.toml
cat < vendor_cargoconf.toml >> .cargo/config.toml
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

# don't package tests
find %buildroot%python3_sitelibdir -type d -name tests | \
    xargs -I {} rm -rf "{}"

# don't remove libcst/codemod/_testing.py and libcst/testing/
# contains CodemodTest class which provides testing facility for Codemods

%check
export NO_PYRE=yes
%pyproject_run -- bash -s <<-'ENDTESTS'
set -eux
cd %mod_name
export LIBCST_PARSER_TYPE=native
python -m %mod_name.tests

export LIBCST_PARSER_TYPE=pure
python -m %mod_name.tests
ENDTESTS

%files
%doc README.rst
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
