%define oname libnacl

Name: python3-module-%oname
Version: 2.1.0
Release: alt1

Summary: Python ctypes wrapper for libsodium

License: Apache-2.0
Group: Development/Python3
Url: https://github.com/saltstack/libnacl
Packager: Python Development Team <python@packages.altlinux.org>
BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-poetry-core
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%{?!_without_check:%{?!_disable_check:BuildRequires: libsodium-devel}}

Requires: libsodium


%description
This library is used to gain direct access to the functions exposed by
Daniel J. Bernstein's nacl library via libsodium. It has been constructed
to maintain extensive documentation on how to use nacl as well as being
completely portable. The file in libnacl/__init__.py can be pulled out
and placed directly in any project to give a single file binding to all
of nacl.


%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_unittest discover --start-directory tests -v

%files
%doc LICENSE MANIFEST.in README.rst doc/index.rst doc/topics
%python3_sitelibdir/*


%changelog
