%define oname logilab-constraint

%def_with check

Name: python3-module-%oname
Version: 1.0
Release: alt1

Summary: A constraint satisfaction problem solver written in 100%% pure Python
License: LGPL
Group: Development/Python3
URL: https://pypi.org/project/logilab-constraint

BuildArch: noarch

Source: constraint-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-logilab-common
BuildRequires: python3-module-six
%endif

%description
The constraint package is a constraint satisfaction problem solver
written in 100%% pure Python. The implementation uses constraint
propagation algorithms. Constraints and Domain implementations are
provided to work with finite domains and finite intervals. It should be
fairly easy to add new kind of domains such as finite integer domains,
together with specialized constraints.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -v -k 'not Abstract'

%files
%doc COPYING ChangeLog README.* examples
%python3_sitelibdir/logilab
%python3_sitelibdir/logilab_constraint-%version.dist-info

%changelog
