%define _unpackaged_files_terminate_build 1
%define modname mako

%def_with check

Name: python3-module-%modname
Version: 1.3.5
Release: alt1

Summary: A super-fast templating language that borrows the best ideas from the existing templating languages.

Group: Development/Python3
License: MIT
URL: https://pypi.org/project/Mako
VCS: https://github.com/sqlalchemy/mako

Source: %name-%version.tar

BuildArch: noarch

# Fix #23203
Requires: python3-module-beaker

Conflicts: python-module-mako < %EVR
Obsoletes: python-module-mako < %EVR

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3

%if_with check
# install_requires:
BuildRequires: python3(markupsafe)

BuildRequires: python3(pytest)
BuildRequires: python3(tox)
BuildRequires: python3(tox_console_scripts)
BuildRequires: python3(tox_no_deps)
%endif

# conditional import, but unconditionally required
%py3_requires markupsafe

%description
Mako is a template library written in Python. It provides a familiar,
non-XML syntax which compiles into Python modules for maximum
performance. Mako's syntax and API borrows from the best ideas of many
others, including Django templates, Cheetah, Myghty, and Genshi.
Conceptually, Mako is an embedded Python (i.e. Python Server Page)
language, which refines the familiar ideas of componentized layout and
inheritance to produce one of the most straightforward and flexible
models available, while also maintaining close ties to Python calling
and scoping semantics.

%package tests
Summary: template library written in Python
Group: Development/Python3
License: MIT

%description tests
Mako is a template library written in Python. It provides a familiar,
non-XML syntax which compiles into Python modules for maximum
performance. Mako's syntax and API borrows from the best ideas of many
others, including Django templates, Cheetah, Myghty, and Genshi.
Conceptually, Mako is an embedded Python (i.e. Python Server Page)
language, which refines the familiar ideas of componentized layout and
inheritance to produce one of the most straightforward and flexible
models available, while also maintaining close ties to Python calling
and scoping semantics.

This package contains tests for %modname.

%prep
%setup

%build
%python3_build

%install
%python3_install
%python3_prune

%check
py.test-3 -v

%files
%doc CHANGES LICENSE README*
%_bindir/mako-render
%python3_sitelibdir/mako
%python3_sitelibdir/Mako-%{version}*.egg-info
%exclude %python3_sitelibdir/mako/testing

%files tests
%doc CHANGES LICENSE README*
%python3_sitelibdir/mako/testing

%changelog
