%define  modulename metaextract

%def_with check

Name:    python3-module-%modulename
Version: 1.0.9
Release: alt4

Summary: Get metadata for python modules
License: Apache-2.0
Group:   Development/Python3
URL:     https://github.com/toabctl/metaextract

Packager: Andrey Cherepanov <cas@altlinux.org>

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pbr
%endif

BuildArch: noarch

Source:  %modulename-%version.tar
Patch: metaextract-1.0.9-fix-tests.patch

%description
metaextract is a tool to collect metadata about a python module. For example
you may have a sdist tarball from the Python Package Index and you want to know
it's dependencies. metaextract can collect theses dependencies. The tool was
first developed in py2pack but is now it's own module to be useful for others,
too.

%prep
%setup -n %modulename-%version
%patch -p1

grep -rl "distutils.core" | xargs sed -i 's/distutils.core/setuptools/'

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest

%files
%doc LICENSE *.rst
%_bindir/metaextract
%python3_sitelibdir/%modulename
%python3_sitelibdir/%modulename-%version.dist-info

%changelog
