%define _unpackaged_files_terminate_build 1
%define oname modepy

%def_without docs

Name: python3-module-%oname
Version: 2016.1.2
Release: alt3

Summary: Modes and nodes for high-order discretizations
License: MIT
Group: Development/Python3
Url: https://documen.tician.de/modepy/
# https://github.com/inducer/modepy.git
BuildArch: noarch

Source: %name-%version.tar
Patch1: %oname-alt-docs.patch

BuildRequires(pre): rpm-build-python3


%description
modepy helps you create well-behaved high-order discretizations on
simplices (i.e. triangles and tetrahedra). These are a key building
block for high-order unstructured discretizations, as often used in a
finite element context.

The basic objects that modepy manipulates are functions on a simplex.
For example, it supplies an orthonormal basis on triangles (shown here)
and tetrahedra.

%package pickles
Summary: Pickles for modepy
Group: Development/Python3

%description pickles
modepy helps you create well-behaved high-order discretizations on
simplices (i.e. triangles and tetrahedra). These are a key building
block for high-order unstructured discretizations, as often used in a
finite element context.

The basic objects that modepy manipulates are functions on a simplex.
For example, it supplies an orthonormal basis on triangles (shown here)
and tetrahedra.

This package contains pickles for modepy.

%package doc
Summary: Documentation for modepy
Group: Development/Documentation

%description doc
modepy helps you create well-behaved high-order discretizations on
simplices (i.e. triangles and tetrahedra). These are a key building
block for high-order unstructured discretizations, as often used in a
finite element context.

The basic objects that modepy manipulates are functions on a simplex.
For example, it supplies an orthonormal basis on triangles (shown here)
and tetrahedra.

This package contains documentation for modepy.

%prep
%setup
%patch1 -p1

%if_with docs
sed -i 's|sphinx-build|sphinx-build-3|' doc/Makefile
%endif

%build
%python3_build_debug

%install
%python3_install

%if_with docs
export PYTHONPATH=%buildroot%python3_sitelibdir
%make -C doc pickle
%make -C doc html

cp -fR doc/_build/pickle %buildroot%python3_sitelibdir/%oname/
%endif

%files
%doc LICENSE
%doc README.rst
%python3_sitelibdir/*
%if_with docs
%exclude %python_sitelibdir/%oname/pickle
%endif

%if_with docs
%files pickles
%python3_sitelibdir/%oname/pickle

%files doc
%doc doc/_build/html/*
%endif


%changelog
