%define oname multidict

%def_with check

Name: python3-module-%oname
Version: 6.0.5
Release: alt1

Summary: Multidicts are useful for working with HTTP headers, URL query args etc

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.python.org/pypi/multidict
Packager: Anton Midyukov <antohami@altlinux.org>

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-Cython
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-cov
%endif

%description
HTTP Headers and URL query string require specific data structure: multidict.
It behaves mostly like a dict but it can have several values for the same key.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install
rm -vf %buildroot%python3_sitelibdir/%oname/*.{c,pyx}

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
# test_circular_imports try to import from the system and the module
# is installed in the buildroot at this point.
py.test-3 -v --ignore tests/test_circular_imports.py

%files
%doc LICENSE *.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
