%define _unpackaged_files_terminate_build 1
%define oname natsort

# m2r2 is not ready for new mistune
%def_without docs
%def_with check

Name: python3-module-%oname
Version: 8.4.0
Release: alt2

Summary: Sort lists naturally
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/natsort/
BuildArch: noarch

# https://github.com/SethMMorton/natsort.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
BuildRequires: python3(hypothesis)
BuildRequires: python3(pytest_cov)
BuildRequires: python3(pytest-mock)
BuildRequires: python3(tox)
BuildRequires: python3(coverage)
BuildRequires: python3(semver)
%endif

%if_with docs
BuildRequires: python3-module-sphinx-devel
BuildRequires: python3-module-m2r2
BuildRequires: python3(sphinx_rtd_theme)
%endif

%description
Natural sorting for python.

%if_with docs
%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
Natural sorting for python.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
Natural sorting for python.

This package contains documentation for %oname.
%endif # docs

%prep
%setup

echo '' > dev/requirements.txt

%build
%pyproject_build

%install
%pyproject_install

%if_with docs
export PYTHONPATH=$PWD
pushd docs
sphinx-build-3 -b pickle -d build/doctrees . build/pickle
sphinx-build-3 -b html -d build/doctrees . build/html
popd

cp -fR docs/build/pickle %buildroot%python3_sitelibdir/%oname/
%endif

%check
%tox_create_default_config
%tox_check_pyproject

%files
%doc *.rst
%_bindir/natsort
%python3_sitelibdir/natsort/
%python3_sitelibdir/*.dist-info/

%if_with docs
%exclude %python3_sitelibdir/*/pickle

%files pickles
%python3_sitelibdir/*/pickle

%files docs
%doc docs/build/html/*
%endif


%changelog
