%define _unpackaged_files_terminate_build 1
%define oname nibabel

%def_disable docs

# on armh couple tests failed
# FAILED nibabel/tests/test_arraywriters.py::test_rt_bias
# FAILED nibabel/tests/test_round_trip.py::test_round_trip
%ifnarch armh
%def_with check
%else
%def_without check
%endif

Name: python3-module-%oname
Version: 5.2.1
Release: alt2

Summary: Easy access to NIfTI images from within Python
License: MIT
Group: Development/Python3
URL: https://pypi.org/project/nibabel
Vcs: https://github.com/nipy/nibabel

BuildArch: noarch

Source: %oname-%version.tar
Patch: drop-distutils.patch
Patch1: nibabel-5.2.1-tests-replace-deprecated-nose-fixtures-with-pytest-s.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-hatchling
BuildRequires: python3-module-hatch-vcs
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-xdist
BuildRequires: python3-module-pytest-httpserver
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-modules-sqlite3
%endif

Conflicts: python-module-%oname

%description
NiBabel aims to provide easy access to NIfTI images from within Python.
It uses SWIG-generated wrappers for the NIfTI reference library and
provides the nifti.image.NiftiImage class for Python-style access to the
image data.

While NiBabel is not yet complete (i.e. doesn't support everything the
C library can do), it already provides access to the most important
features of the NIfTI-1 data format and libniftiio capabilities.

%package tests
Summary: Tests for NiBabel
Group: Development/Python3
Requires: %name = %EVR

%description tests
NiBabel aims to provide easy access to NIfTI images from within Python.
It uses SWIG-generated wrappers for the NIfTI reference library and
provides the nifti.image.NiftiImage class for Python-style access to the
image data.

This package contains tests for NiBabel.

%if_enabled docs
%package doc
Summary: Documentation and examples for NiBabel
Group: Development/Documentation
BuildArch: noarch

%description doc
NiBabel aims to provide easy access to NIfTI images from within Python.
It uses SWIG-generated wrappers for the NIfTI reference library and
provides the nifti.image.NiftiImage class for Python-style access to the
image data.

This package contains documentation and examples for NiBabel.

%package pickles
Summary: Pickles for NiBabel
Group: Development/Python3

%description pickles
NiBabel aims to provide easy access to NIfTI images from within Python.
It uses SWIG-generated wrappers for the NIfTI reference library and
provides the nifti.image.NiftiImage class for Python-style access to the
image data.

This package contains pickles for NiBabel.
%endif

%prep
%setup
%autopatch -p1

%if_enabled docs
sed -i 's|@PYVER@|%_python3_version|g' doc/Makefile
sed -i 's|PYTHON ?=.*|PYTHON ?= %__python3|g' doc/Makefile
sed -i 's|sphinx-build|&-3|' doc/Makefile
%endif

%build
if [ ! -d .git ]; then
    git init
    git config user.email author@example.com
    git config user.name author
    git add .
    git commit -m 'release'
    git tag '%version'
fi
%pyproject_build

%install
%pyproject_install

%if_enabled docs
cp -f doc/source/conf.py %buildroot%python3_sitelibdir
export PYTHONPATH=%buildroot%python3_sitelibdir
pushd doc
%make html
popd

install -d %buildroot%_docdir/%oname
cp -fR build/html %buildroot%_docdir/%oname/
cp -fR build/pickle %buildroot%python3_sitelibdir/%oname/
%endif

%check
%pyproject_run_pytest -v

%files
%doc README.*
%_bindir/*
%python3_sitelibdir/nisext
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}
%if_enabled docs
%exclude %python3_sitelibdir/%oname/pickle
%endif
%exclude %python3_sitelibdir/nisext/test*
%exclude %python3_sitelibdir/%oname/tests
%exclude %python3_sitelibdir/%oname/testing
%exclude %python3_sitelibdir/%oname/*/tests

%if_enabled docs
%files doc
%_docdir/%oname

%files pickles
%dir %python3_sitelibdir/%oname
%python3_sitelibdir/%oname/pickle
%endif

%files tests
%python3_sitelibdir/nisext/test*
%python3_sitelibdir/%oname/tests
%python3_sitelibdir/%oname/testing
%python3_sitelibdir/%oname/*/tests

%changelog
