%define  oname numba

# check runs more then half of a day
%def_without check

Name:    python3-module-%oname
Version: 0.59.0
Release: alt0.rc1

Summary: A Just-In-Time Compiler for Numerical Functions in Python

License: BSD
Group:   Development/Python3
URL:     https://pypi.org/project/numba

Packager: Grigory Ustinov <grenka@altlinux.org>

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++ libgomp-devel libnumpy-py3-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

Source:  %name-%version.tar

%add_python3_self_prov_path %buildroot%python3_sitelibdir/%oname/tests/pycc_distutils_usecase/

%add_python3_req_skip numba_rvsdg.core.datastructures
%add_python3_req_skip numba_rvsdg.core.datastructures.basic_block
%add_python3_req_skip numba_rvsdg.core.datastructures.byte_flow
%add_python3_req_skip numba_rvsdg.core.datastructures.scfg
%add_python3_req_skip numba_rvsdg.rendering.rendering

%description
Numba is an open source, NumPy-aware optimizing compiler for Python sponsored by
Anaconda, Inc. It uses the LLVM compiler project to generate machine code from
Python syntax.

Numba can compile a large subset of numerically-focused Python, including many
NumPy functions. Additionally, Numba has support for automatic parallelization
of loops, generation of GPU-accelerated code, and creation of ufuncs and
C callbacks.

%prep
%setup
sed -i 's/@VERSION@/%version/' setup.py
sed -i 's|"version": "0+unknown"|"version": "%version"|' versioneer.py

%ifarch %e2k
# error: misspelling pragma string
sed -i "/omp parallel/s/),/)/" numba/np/ufunc/omppool.cpp
%endif

%build
%pyproject_build

%install
%pyproject_install

mv %buildroot%_bindir/numba %buildroot%_bindir/numba3

%check
mkdir emtpytestdir
pushd emtpytestdir
export PYTHONPATH=%buildroot%python3_sitelibdir
%__python3 -m numba.runtests -v
popd

%files
%doc CHANGE_LOG *.rst
%_bindir/numba3
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
