%define oname numexpr

%def_with check

Name: python3-module-%oname
Version: 2.10.2
Release: alt1.1
Epoch: 1

Summary: Fast numerical array expression evaluator for Python and NumPy

Group: Development/Python3
License: MIT
URL: https://pypi.org/project/numexpr
VCS: https://github.com/pydata/numexpr

Source: %name-%version.tar
Source1: site.cfg
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: libnumpy-py3-devel

BuildRequires: gcc-c++ liblapack-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: /proc
BuildRequires: python3(numpy.testing)
%endif

%description
The numexpr package evaluates multiple-operator array expressions many
times faster than NumPy can. It accepts the expression as a string,
analyzes it, rewrites it more efficiently, and compiles it to faster
Python code on the fly. It's the next best thing to writing the
expression in C and compiling it with a specialized just-in-time (JIT)
compiler, i.e. it does not require a compiler at runtime.

Also, numexpr has support for the Intel VML (Vector Math Library) --
integrated in Intel MKL (Math Kernel Library) --, allowing nice
speed-ups when computing transcendental functions (like trigonometrical,
exponentials...) on top of Intel-compatible platforms. This support also
allows to use multiple cores in your computations.

%prep
%setup
%autopatch -p1

install -p -m644 %SOURCE1 ./
sed -i 's|@LIBDIR@|%_libdir|' site.cfg
%ifnarch %ix86 x86_64 armh aarch64 ppc64le %e2k
sed -i 's@ openblas,@ blas,@' site.cfg
%endif
sed -i 's|@PYVER@|%_python3_version%_python3_abiflags|' \
	site.cfg

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install

%check
# see .github/workflows/build.yml
cat > tox.ini <<'EOF'
[testenv]
changedir = empty
commands =
    python -c 'import sys, numexpr; sys.exit(0 if numexpr.test().wasSuccessful() else 1)'
EOF
%tox_check_pyproject

%files
%doc *.txt *.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
