%define oname numpy-stl

Name: python3-module-%oname
Version: 3.1.1
Release: alt1

Summary: Library to make reading, writing and modifying both binary and ascii STL files easy

License: BSD-3-Clause
Group: Development/Python3
URL: https://pypi.org/project/numpy-stl
VCS: https://github.com/WoLpH/numpy-stl

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

BuildRequires: python3-module-matplotlib
BuildRequires: python3-module-python_utils
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-cov
BuildRequires: python3-module-docutils
BuildRequires: python3-module-sphinx
BuildRequires: xvfb-run

%py3_provides stl

%description
Simple library to make working with STL files (and 3D objects in
general) fast and easy.

Due to all operations heavily relying on numpy this is one of the
fastest STL editing libraries for Python available.

%prep
%setup

sed -i 's|sphinx-build|sphinx-build-3|' docs/Makefile

%build
%pyproject_build

%install
%pyproject_install

%make -C docs html

%check
sed -i '/--flake8/d' pytest.ini
%pyproject_run_pytest

%files
%doc *.rst docs/_build/html
%_bindir/*
%python3_sitelibdir/stl
%python3_sitelibdir/*.dist-info

%changelog
