%define oname oslo.i18n
%def_with check
%def_with docs

Name: python3-module-%oname
Version: 6.5.1
Release: alt1.1

Summary: OpenStack Oslo i18n library

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/oslo.i18n

Source: %oname-%version.tar
Source1: %oname.watch
Patch1: oslo.i18n-6.0.0-alt-fix-tests-for-python-3.11.patch

BuildArch: noarch

Provides: python3-module-oslo-i18n = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr >= 2.0.0

%if_with check
BuildRequires: python3-module-oslo.config >= 5.2.0
BuildRequires: python3-module-stestr >= 2.0.0
BuildRequires: python3-module-oslotest >= 3.2.0
BuildRequires: python3-module-hacking >= 6.1.0
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-testscenarios >= 0.4
%endif

%if_with docs
BuildRequires: python3-module-sphinx >= 1.2.1
BuildRequires: python3-module-openstackdocstheme >= 1.18.1
BuildRequires: python3-module-sphinxcontrib-apidoc
%endif

%description
The oslo.i18n library contain utilities for working with internationalization
(i18n) features, especially translation for text strings in an application
or library.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation
Provides: python3-module-oslo-i18n-doc = %EVR

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version
%patch1 -p2

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/osloi18n.1 %buildroot%_man1dir/osloi18n.1
%endif

%check
%__python3 -m stestr run

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%python3_sitelibdir/oslo_i18n
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/oslo_i18n/tests

%files tests
%python3_sitelibdir/oslo_i18n/tests

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/osloi18n.1.xz
%endif

%changelog
