%define _unpackaged_files_terminate_build 1

%define oname pandas

%def_with bootstrap
%def_disable check
%def_without docs

Name: python3-module-%oname
Version: 2.1.4
Release: alt2
Summary: Python Data Analysis Library
License: BSD-3-Clause
Group: Development/Python3

Url: https://pandas.pydata.org

# https://github.com/pandas-dev/pandas.git
Source: %name-%version.tar
Patch1: pandas-fix-generate-version.patch
Patch2: pandas-alt-remove-tests-dependency.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: python3-devel
BuildRequires: libnumpy-py3-devel python3-module-Cython python3-module-numpy
BuildRequires: python3(scipy) python3(xlrd)
BuildRequires: python3-module-mesonpy
BuildRequires: meson
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_enabled check
BuildRequires: xvfb-run
BuildRequires: python3(openpyxl)
BuildRequires: python3-module-numpy-testing python3(tables.tests)
%endif
%if_with docs
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-objects.inv
BuildRequires: pandoc
BuildRequires: xvfb-run python3(nbsphinx)
BuildRequires: python3-module-notebook
BuildRequires: python3(numpydoc) python3(matplotlib.sphinxext) python3(matplotlib.sphinxext.plot_directive)
BuildRequires: python3-module-sphinx python3-module-sphinx-sphinx-build-symlink
%endif

%add_python3_req_skip feather
%add_python3_req_skip numba
%add_python3_req_skip numba.extending
%add_python3_req_skip pyarrow
%py3_requires pytz dateutil numpy sqlalchemy numexpr
%py3_requires scipy bs4 xlrd openpyxl xlsxwriter xlwt
%py3_requires tables
%if_without bootstrap
BuildRequires: python3-module-scikits.statsmodels
%endif

%description
pandas is an open source, BSD-licensed library providing
high-performance, easy-to-use data structures and data analysis tools
for the Python programming language.

%package tests
Summary: Tests for pandas
Group: Development/Python3
Requires: %name = %EVR
%py3_requires numpy.ma.testutils pymysql psycopg2
%if_without bootstrap
%py3_requires statsmodels.stats.multitest
%endif

%description tests
pandas is an open source, BSD-licensed library providing
high-performance, easy-to-use data structures and data analysis tools
for the Python programming language.

This package contains tests for pandas.

%package docs
Summary: Documentation for pandas
Group: Development/Documentation
BuildArch: noarch
Requires: %name = %EVR

%description docs
pandas is an open source, BSD-licensed library providing
high-performance, easy-to-use data structures and data analysis tools
for the Python programming language.

This package contains documentation for pandas.

%prep
%setup
%patch1 -p1
%patch2 -p1

sed -i "s/@VERSION@/%version/" generate_version.py

%if_with docs
%prepare_sphinx3 doc
ln -s ../objects.inv doc/source/
%endif

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install

%if_with docs
pushd doc
PYTHONPATH=$(echo ../build/lib.*) xvfb-run ./make.py html
popd
%endif

%check
xvfb-run python3 setup.py test

%files
%doc *.md
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info
%exclude %python3_sitelibdir/*/tests
%exclude %python3_sitelibdir/*/testing.py
%exclude %python3_sitelibdir/*/_testing*
%exclude %python3_sitelibdir/*/conftest.py
%exclude %python3_sitelibdir/*/*/test*
%exclude %python3_sitelibdir/*/*/_test*
%exclude %python3_sitelibdir/*/*/conftest.*
%exclude %python3_sitelibdir/*/*/*/test*
%exclude %python3_sitelibdir/*/*/*/_test*

%files tests
%python3_sitelibdir/*/tests
%python3_sitelibdir/*/testing.py
%python3_sitelibdir/*/_testing*
%python3_sitelibdir/*/conftest.py
%python3_sitelibdir/*/*/test*
%python3_sitelibdir/*/*/_test*
%python3_sitelibdir/*/*/conftest.*
%python3_sitelibdir/*/*/*/test*
%python3_sitelibdir/*/*/*/_test*

%if_with docs
%files docs
%doc doc/build/html
%endif

%changelog
