%define pypi_name pbr

%def_without doc
%def_with check

%define descr \
PBR is a library that injects some useful and sensible default behaviors \
into your setuptools run. It started off life as the chunks of code that \
were copied between all of the OpenStack projects. Around the time that \
OpenStack hit 18 different projects each with at least 3 active \
branches, it seems like a good time to make that code into a proper \
re-usable library.

Name:       python3-module-%pypi_name
Version:    6.1.1
Release:    alt1.1

Summary:    Python Build Reasonableness

Group:      Development/Python3
License:    Apache-2.0
URL:        https://pypi.org/project/pbr
VCS:        https://opendev.org/openstack/pbr

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3

BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with doc
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-sphinxcontrib-apidoc
%endif

%if_with check
BuildRequires: python3-module-stestr
BuildRequires: python3-module-testresources
BuildRequires: python3-module-six
BuildRequires: git gnupg
%endif

BuildArch:  noarch

Conflicts: python-module-pbr < 5.5.0-alt4

# for python w/o distutils
%filter_from_requires /python3(distutils.*)/d
Requires: python3(setuptools._distutils)

%description
%descr

%prep
%setup
# Remove the requirements file so that pbr hooks don't add it
# to distutils requiers_dist config
rm -rf {test-,}requirements.txt

# Remove bundled egg-info
rm -rf %{pypi_name}.egg-info

%build
export PBR_VERSION="%version"
export SKIP_PIP_INSTALL=1
%pyproject_build

%if_with doc
# generate html docs
sphinx-build-3 doc/source html
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
export PBR_VERSION="%version"
%pyproject_install
rm -rv %buildroot%python3_sitelibdir/%pypi_name/tests

# no idea who use it
rm -fv %buildroot%python3_sitelibdir/%pypi_name/sphinxext.py

%check
# test_console_script_develop: https://bugs.launchpad.net/pbr/+bug/2107732
excluded_tests='test_requirement_parsing|test_pep_517_support|test_wsgi_script_run|test_with_argument|test_console_script_develop'
%tox_check_pyproject -- --exclude-regex "$excluded_tests"

%files
%doc README.rst LICENSE
%if_with doc
%doc html
%endif
%_bindir/*
%python3_sitelibdir/%pypi_name-%version.dist-info
%python3_sitelibdir/%pypi_name

%changelog
