%define oname peewee

%def_disable check

Name: python3-module-%oname
Version: 3.17.1
Release: alt1

Summary: A small, expressive orm -- supports postgresql, mysql and sqlite

License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/peewee/

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

Obsoletes: python-module-peewee
Provides: python-module-peewee

BuildRequires(pre): rpm-macros-intro >= 2.2.4
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx3

BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

BuildRequires: python3-module-sphinx python3-module-sphinx_rtd_theme
BuildRequires: python3-module-pytest python3-modules-sqlite3

BuildRequires: python3-module-Cython

# Keep noarch: Could not find libsqlite3, SQLite extensions will not be built.
BuildRequires: libsqlite3-devel

%add_python3_req_skip pysqlcipher

%description
Peewee is a simple and small ORM. It has few (but expressive) concepts,
making it easy to learn and intuitive to use.

* A small, expressive ORM
* Written in python with support for versions 2.6+ and 3.2+.
* built-in support for sqlite, mysql and postgresql
* tons of extensions available in the playhouse
  (postgres hstore/json/arrays, sqlite full-text-search, schema
  migrations, and much more).


%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
Peewee is a simple and small ORM. It has few (but expressive) concepts,
making it easy to learn and intuitive to use.

This package contains documentation for %oname.

%prep
%setup

find -type f -name '*.py' -exec \
	sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' '{}' +

%prepare_sphinx3 .
ln -s ../objects.inv docs/

%build
%pyproject_build

%install
%pyproject_install
%python3_prune
#[ -d %buildroot%python3_sitelibdir/ ] || mv %buildroot%python3_sitelibdir/
%make -C docs html SPHINXBUILD=sphinx-build-3

%check
python3 setup.py test
python3 runtests.py

%files
%doc *.md *.rst examples
%_bindir/pwiz.py
%python3_sitelibdir/*

%files docs
%doc docs/_build/html/*

%changelog
