%define _unpackaged_files_terminate_build 1
%define oname ptyprocess

%def_with check

Name: python3-module-%oname
Version: 0.7.0
Release: alt1

Summary: Run a subprocess in a pseudo terminal

License: ISCL
Group: Development/Python3
Url: https://pypi.python.org/pypi/ptyprocess

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: /dev/pts
BuildRequires: python3-module-pytest
%endif

BuildArch: noarch

%description
Launch a subprocess in a pseudo terminal (pty), and interact with both
the process and its pty.

Sometimes, piping stdin and stdout is not enough. There might be a
password prompt that doesn't read from stdin, output that changes when
it's going to a pipe rather than a terminal, or curses-style interfaces
that rely on a terminal. If you need to automate these things, running
the process in a pseudo terminal (pty) is the answer.

%prep
%setup

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
	tests/test_invalid_binary.py \
	tests/test_preexec_fn.py

%build
%python3_build

%install
%python3_install

%check
py.test3 -v

%files
%doc README.rst docs/*.rst
%python3_sitelibdir/ptyprocess/
%python3_sitelibdir/ptyprocess-*.egg-info

%changelog
