%define _unpackaged_files_terminate_build 1
%define oname pycobertura

%def_with check

Name: python3-module-%oname
Version: 0.10.5
Release: alt4

Summary: A Cobertura coverage report parser written in Python
License: MIT
Group: Development/Python3
BuildArch: noarch
Url: https://pypi.python.org/pypi/pycobertura/

# https://github.com/SurveyMonkey/pycobertura.git
Source: %name-%version.tar
Patch: pycobertura-0.10.5-Fix-Pytest4.x-compatibility-error.patch

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3

%if_with check
# generated by epm restore --dry-run from python3-module-pycobertura/test-requirements.txt
#py3_buildrequires coverage < 4.4
%py3_buildrequires coverage >= 4.0
%py3_buildrequires mock
%py3_buildrequires pytest-cov
BuildRequires: pytest3
%endif

# generated by epm restore --dry-run from python3-module-pycobertura/setup.py install_requires
%py3_use click >= 4.0
%py3_use colorama
%py3_use jinja2
%py3_use lxml
%py3_use tabulate

%py3_provides %oname


%description
A Cobertura coverage report parser written in Python.

%prep
%setup
%patch -p1
# unpin test requirements
sed -i 's/,\?<.*//g' test-requirements.txt

grep -qsF 'setuptools_git' setup.py || exit 1
sed -i -e 's|setuptools_git|setuptools|g' setup.py

%build
%python3_build_debug

%install
%python3_install

%check
export LC_ALL=en_US.UTF-8
pytest3 -v .

%files
%doc *.md
%_bindir/*
%python3_sitelibdir/*


%changelog
