%define oname pygame

Name: python3-module-pygame
Version: 2.5.2
Release: alt1

Summary: A Python module for interfacing with the SDL multimedia library
Summary(ru_RU.UTF-8): Расширение языка Python для работы с библиотекой SDL

Group: Development/Python3
License: LGPL-2.1
Url: https://www.pygame.org

# Source-url: https://github.com/pygame/pygame/archive/refs/tags/%version.tar.gz
Source: %name-%version.tar
Patch: pygame-2.1.0-docs.patch

%define python3_includedir %_includedir/python%_python3_version

BuildRequires(pre): rpm-build-python3

BuildRequires: libfreetype-devel
BuildRequires: libSDL2_image-devel libSDL2_mixer-devel libSDL2_ttf-devel
BuildRequires: libjpeg-devel libpng-devel libportmidi-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-Cython
BuildRequires: python3-module-sphinx python3-module-sphinx-sphinx-build-symlink

Requires: libSDL >= 1.2.7

%add_python3_req_skip AppKit Foundation py2app Numeric opencv


%description
pygame is a Python wrapper module for the SDL multimedia library, written by
Pete Shinners.  It contains python functions and classes that will allow you
to use SDL's support for playing cdroms, audio and video output, and keyboard,
mouse and joystick input. pygame also includes support for the Numerical
Python extension. pygame is the successor to the pySDL wrapper project, written
by Mark Baker.

Install %name if you would like to write or play SDL games written in the
python language.

%description -l ru_RU.UTF-8
pygame - расширение языка программирования Python, позволяющее
использовать возможности мультимедийной библиотеки SDL (Simple
DirectMedia Layer), предоставляющей низкоуровневый доступ к звуковым
устройствам, клавиатуре, манипулятору мышь и к буферу экрана на
множестве различных платформ.


%package devel
Summary: Pygame development headers (Python 3)
Group: Development/Python3
BuildArch: noarch
Requires: %name = %EVR

%description devel
pygame is a Python wrapper module for the SDL multimedia library, written by
Pete Shinners.  It contains python functions and classes that will allow you
to use SDL's support for playing cdroms, audio and video output, and keyboard,
mouse and joystick input. pygame also includes support for Numerical Python
extension. pygame is the successor to the pySDL wrapper project, written by
Mark Baker.

Install %name-devel if you need the c/c++ include files.

%package doc
Summary: Pygame documentation and example programs (Python3 version)
Group: Development/Python3
#Requires: %name = %EVR
BuildArch: noarch

%description doc
Pygame documentation and example programs (Python3 version)

%prep
%setup
%patch -p1

%build
%python3_build_debug
python3 setup.py docs

%install
%python3_install
sed -i '/^pkg_dir =/s@pkg_dir = .*@pkg_dir = "%_defaultdocdir/python3-module-pygame-doc-%version"@' %buildroot%python3_sitelibdir/%oname/docs/__main__.py

%files
%python3_sitelibdir/*

%files doc
%doc docs/.

%files devel
%python3_includedir/%oname/


%changelog
