%define pypi_name pymeeus
%define _name PyMeeus
%def_enable check

Name: python3-module-%pypi_name
Version: 0.5.12
Release: alt1.2

Summary: Library of astronomical algorithms in Python
Group: Development/Python3
License: GPL-3.0 and LGPL-3.0
Url: https://pypi.python.org/pypi/%_name

Vcs: https://github.com/architest/pymeeus

Source: https://pypi.io/packages/source/P/%_name/%_name-%version.tar.gz
#https://github.com/architest/pymeeus/pull/25/commits/f064abfda6b3cb48cb42a6827cd250413056f227
Patch1: PyMeeus-0.5.12-up-pytest-0.7.2.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute python3(wheel)
%{?_enable_check:BuildRequires: python3-module-pytest python3-module-pytest-cov
BuildRequires: python3-module-mccabe}

%description
PyMeeus is a Python 3 implementation of the astronomical algorithms
described in the classical book "Astronomical Algorithms, 2nd Edition,
Willmann-Bell Inc. (1998)" by Jean Meeus.

%prep
%setup -n %_name-%version
%patch1 -p1

%build
%pyproject_build

%install
%pyproject_install

%check
export PYTHONPATH=%buildroot/%python3_sitelibdir_noarch
py.test3 tests

%files
%python3_sitelibdir_noarch/%pypi_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%doc *.rst *.md

%changelog
