%define _unpackaged_files_terminate_build 1

%define pypi_name pysndfile
%def_disable check

Name: python3-module-%pypi_name
# see _pysndfile_version in _pysndfile.pyx
Version: 1.4.7
Release: alt1

Summary: Cython wrapper class for reading/writing soundfiles using libsndfile
License: LGPL-3.0-or-later
Group: Development/Python3
Url: https://pypi.python.org/pypi/pysndfile/

Vcs: https://forge-2.ircam.fr/roebel/pysndfile.git

#Source: https://pypi.io/packages/source/p/pysndfile/pysndfile-%version.tar.gz
Source: %pypi_name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++ libsndfile-devel
BuildRequires: python3-devel python3(wheel) python3(setuptools)
BuildRequires: python3(cython) libnumpy-py3-devel
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-html5lib python3-module-notebook

%description
pysndfile is a python package providing PySndfile, a Cython wrapper
class around libsndfile. PySndfile provides methods for reading and
writing a large variety of soundfile formats on a variety of plattforms.
PySndfile provides a rather complete access to the different sound file
manipulation options that are available in libsndfile.

Due to the use of libsndfile nearly all sound file formats, (besides mp3
and derived formats) can be read and written with PySndfile.

%prep
%setup -n %pypi_name-%version
# fix lib/inc dirs
echo -e "sndfile_libdir=%_libdir" >> setup.cfg
echo -e "sndfile_incdir=%_includedir" >> setup.cfg

%build
%pyproject_build

%install
%pyproject_install

%check
export CFLAGS="%optflags"
export CXXFLAGS="%optflags"
export FFLAGS="%optflags"
export PYTHONPATH=%buildroot%python3_sitelibdir

#%__python3 setup.py test
%__python3 tests/pysndfile_test.py

%files
%doc ChangeLog README.*
%python3_sitelibdir/%pypi_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
