%define _unpackaged_files_terminate_build 1

%define oname pyublas

%def_without docs

Name: python3-module-%oname
Version: 2017.1
Release: alt2.1

Summary: Seamless Numpy-UBlas interoperability
License: BSD
Group: Development/Python3
Url: http://mathema.tician.de/software/pyublas

# http://git.tiker.net/trees/pyublas.git
Source: %name-%version.tar

Patch1: %oname-%version-alt-armh-build.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++ boost-python3-devel libnumpy-py3-devel
# A copy of the imp module that was removed in Python 3.12.
# It shouldn't be used, should use `importlib.metadata` instead.
BuildRequires: python3-module-zombie-imp
%if_with docs
BuildRequires: python3-module-sphinx
%endif

%description
PyUblas provides a seamless glue layer between Numpy and Boost.Ublas for
use with Boost.Python.

%package devel
Summary: Development files of PyUblas
Group: Development/Python3
Requires: %name = %version-%release

%description devel
PyUblas provides a seamless glue layer between Numpy and Boost.Ublas for
use with Boost.Python.

This package contains development files of PyUblas.

%if_with docs
%package docs
Summary: Documentation for PyUblas
Group: Development/Documentation
BuildArch: noarch

%description docs
PyUblas provides a seamless glue layer between Numpy and Boost.Ublas for
use with Boost.Python.

This package contains documentation for PyUblas.
%endif

%package pickles
Summary: Pickles for PyUblas
Group: Development/Python3

%description pickles
PyUblas provides a seamless glue layer between Numpy and Boost.Ublas for
use with Boost.Python.

This package contains pickles for PyUblas.

%prep
%setup
%patch1 -p1

sed -i 's|#!.*python|&3|' configure.py
sed -i 's|sphinx-build|&-3|' doc/Makefile

%build
./configure.py \
    --boost-python-libname=boost_python%{python_version_nodots python3}
%python3_build_debug

%if_with docs
%make -C doc html
%endif

%install
%python3_install

install -d %buildroot%_includedir
ln -s %python3_sitelibdir/pyublas/include/pyublas %buildroot%_includedir/

%if_with docs
cp -fR doc/build/pickle %buildroot%python3_sitelibdir/%oname/
%endif

%pre devel
rm -fR %_includedir/pyublas

%files
%python3_sitelibdir/*
%exclude %python3_sitelibdir/pyublas/include
%if_with docs
%exclude %python3_sitelibdir/%oname/pickle

%files docs
%doc doc/.build/html

%files pickles
%python3_sitelibdir/%oname/pickle
%endif

%files devel
%doc test/*
%_includedir/%oname
%python3_sitelibdir/pyublas/include

%changelog
