Name:           python3-module-rtslib
Version:        2.2.3
Release:        alt1

Summary:        API for Linux kernel LIO SCSI target

License:        Apache-2.0
Group:          Development/Python3
URL:            https://github.com/open-iscsi/rtslib-fb

Source:         %name-%version.tar

BuildArch:      noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-hatchling
BuildRequires: python3-module-hatch-vcs

Requires: python3-module-kmod

%description
API for generic Linux SCSI kernel target. Includes the 'target'
service and targetctl tool for restoring configuration.

%package -n target-restore
Summary:        Systemd service for targetcli/rtslib
Group:          System/Servers

%description -n target-restore
Systemd service to restore the LIO kernel target settings
on system restart.

%prep
%setup

sed 's|/var/target|/var/lib/target|' -i rtslib/root.py

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
gzip --stdout doc/targetctl.8 > doc/targetctl.8.gz
gzip --stdout doc/saveconfig.json.5 > doc/saveconfig.json.5.gz

%pyproject_build

%install
%pyproject_install
mkdir -p %buildroot{%_man8dir,%_man5dir,%_unitdir,%_sysconfdir/target/backup,%_localstatedir/target/{pr,alua}}

install -m 644 systemd/target.service %buildroot%_unitdir/target.service
install -m 644 doc/targetctl.8.gz %buildroot%_man8dir/
install -m 644 doc/saveconfig.json.5.gz %buildroot%_man5dir/

%post -n target-restore
%post_service target

%preun -n target-restore
%preun_service target

%files
%doc COPYING README.md doc/getting_started.md
%python3_sitelibdir/*

%files -n target-restore
%_bindir/targetctl
%_unitdir/target.service
%dir %_sysconfdir/target
%dir %_sysconfdir/target/backup
%dir %_localstatedir/target
%dir %_localstatedir/target/pr
%dir %_localstatedir/target/alua
%_man8dir/targetctl.8.*
%_man5dir/saveconfig.json.5.*

%changelog
