%define oname scikit-learn

# CPU time limit exceeded
# 1.4.0 passes check on local machine
%def_without check

Name: python3-module-%oname
Version: 1.4.0
Release: alt2

Summary: A set of python modules for machine learning and data mining

License: BSD-3-Clause
Group: Development/Python3
URL: https://pypi.org/project/scikit-learn
VCS: https://github.com/scikit-learn/scikit-learn

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: liblapack-devel
%ifnarch %e2k
BuildRequires: libgomp-devel
%endif
BuildRequires: libnumpy-py3-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-numpy
BuildRequires: python3-module-scipy
BuildRequires: python3-module-Cython

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-joblib
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-threadpoolctl
BuildRequires: python3-module-contourpy
%endif

%py3_provides sklearn

%description
scikit-learn is a Python module for machine learning built on top of
SciPy and distributed under the 3-Clause BSD license.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
scikit-learn is a Python module for machine learning built on top of
SciPy and distributed under the 3-Clause BSD license.

This package contains tests for %oname.

%prep
%setup

%build
export BLAS=openblas
%pyproject_build

%install
%pyproject_install

%check
pushd %buildroot%python3_sitelibdir
py.test3 -vv
rm -rv .pytest_cache
popd

%files
%doc COPYING *.md *.rst
%python3_sitelibdir/sklearn
%python3_sitelibdir/scikit_learn-%version.dist-info
%python3_sitelibdir/sklearn/tests
%python3_sitelibdir/sklearn/*/tests
%python3_sitelibdir/sklearn/*/*/tests
%python3_sitelibdir/sklearn/utils/_testing.py
%python3_sitelibdir/sklearn/utils/__pycache__/_testing.*

%changelog
