%define mname scikits
%define oname %mname.bootstrap

%def_with check

Name: python3-module-%oname
Version: 1.1.0
Release: alt6.1

Summary: Bootstrap confidence interval estimation routines for Numpy/Scipy/Pandas
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.org/project/scikits.bootstrap/
VCS: https://github.com/cgevans/scikits-bootstrap.git

Source: %name-%version.tar
# backported from d9ebd7e727595cabbc8e949584396a42b14a90d5
Patch0: scikits.bootstrap-1.1.0-fix-pytest-8-compatibility.patch
# backported from b00f5ec14e946c78269d66e67aecbfd979bd7f27
Patch1: scikits.bootstrap-1.1.0-remove-pyerf-dependency.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-pytest
%endif

%py3_provides %oname

%description
Scikits.bootstrap provides bootstrap statistics confidence interval algorithms
for Numpy/Scipy/Pandas. It originally required scipy, but no longer needs it.

It also provides an algorithm which estimates the probability that the
statistics lies satisfies some criteria, e.g., lies in some interval.

%prep
%setup
%autopatch -p1

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%pyproject_build

%install
%pyproject_install

%if "%python3_sitelibdir" != "%python3_sitelibdir_noarch"
mkdir -p %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* %buildroot%python3_sitelibdir/
%endif

%check
%ifarch %ix86
%define pytest_args -k 'not test_abc_simple'
%endif
%pyproject_run_pytest -ra %{?pytest_args}

%files
%doc LICENSE *.md
%python3_sitelibdir/%mname
%python3_sitelibdir/%{pyproject_distinfo %oname}/

%changelog
