%define pypi_name sphinx-autobuild

%def_with check

Name:    python3-module-%pypi_name
Version: 2024.10.3
Release: alt2

Summary: Watch a Sphinx directory and rebuild the documentation when a change is detected

License: MIT
Group:   Development/Python3
URL:     https://pypi.org/project/sphinx-autobuild
VCS:     https://github.com/executablebooks/sphinx-autobuild

Packager: Grigory Ustinov <grenka@altlinux.org>

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-flit

%if_with check
# pyproject.toml:dependencies
BuildRequires: python3-module-colorama
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-starlette
BuildRequires: python3-module-uvicorn
BuildRequires: python3-module-watchfiles
BuildRequires: python3-module-websockets
# pyproject.toml:optional-dependencies.test
BuildRequires: python3-module-httpx
BuildRequires: python3-module-pytest
%endif

BuildArch: noarch

Source: %name-%version.tar

%description
Watch a Sphinx directory and rebuild the documentation when a change is detected.
Also includes a livereload enabled web server.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_create_default_config
%tox_check_pyproject

%files
%doc *.rst
%_bindir/sphinx-autobuild
%python3_sitelibdir/sphinx_autobuild
%python3_sitelibdir/sphinx_autobuild-%version.dist-info

%changelog
