%define modname sphinx-autodoc-typehints
%define pypi_name sphinx_autodoc_typehints
%def_disable check

Name: python3-module-%modname
Version: 3.1.0
Release: alt1

Summary: Type hints (PEP 484) support for the Sphinx autodoc extension
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/%modname

Vcs: https://github.com/tox-dev/sphinx-autodoc-typehints.git
#Source: https://github.com/tox-dev/%modname/archive/%version/%modname-%version.tar.gz
Source: https://pypi.io/packages/source/s/%modname/%pypi_name-%version.tar.gz

BuildArch: noarch
Provides: python3-module-%pypi_name = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(wheel) python3(hatchling) python3(hatch-vcs)
%{?_enable_check:BuildRequires: python3-module-tox >= 4.23.2
BuildRequires: python3-module-sphinx-tests python3-module-snowballstemmer >= 2.0
BuildRequires: python3-module-diff-cover
BuildRequires: python3-module-pytest-cov python3-module-sphobjinv
BuildRequires: python3-module-coverage python3-module-covdefaults
BuildRequires: python3-module-twine python3-module-nptyping}

%description
This Sphinx extension allows to use Python 3 annotations for
documenting acceptable argument types and return value types of
functions.

%prep
%setup -n %pypi_name-%version

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_check

%files
%python3_sitelibdir_noarch/%pypi_name
%python3_sitelibdir_noarch/%{pyproject_distinfo %pypi_name}
%doc README*


%changelog
