%define _unpackaged_files_terminate_build 1
%define pypi_name sphinxcontrib-programoutput
%define modulename %pypi_name

%def_with check

Name:    python3-module-%modulename
Version: 0.17
Release: alt2

Summary: Sphinx extension for capturing program output

License: BSD-2-Clause
Group:   Development/Python3
URL:     https://github.com/NextThought/sphinxcontrib-programoutput

Packager: Grigory Ustinov <grenka@altlinux.org>

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-intro
# build backend and its deps
BuildRequires: python3-module-setuptools

%if_with check
BuildRequires: python3-module-pytest python3-module-docutils
BuildRequires: python3-module-sphinx strace
%endif

BuildArch: noarch

Source:  %modulename-%version.tar

%description
A Sphinx extension to literally insert the output of arbitrary commands into
documents, helping you to keep your command examples up to date.

%prep
%setup -n %modulename-%version

%build
%pyproject_build

%install
%pyproject_install
%python3_prune

# remove .pth file which is useless under python3 and breaks namespace modules
rm %buildroot%python3_sitelibdir/*programoutput*.pth

%check
%pyproject_run_unittest discover -s src/sphinxcontrib

%files
%python3_sitelibdir/sphinxcontrib/programoutput/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%doc *.rst

%changelog
