%define _unpackaged_files_terminate_build 1
%define pypi_name spyder-kernels
%define mod_name spyder_kernels

%def_with check

Name: python3-module-%pypi_name
Version: 3.0.5
Release: alt1

Summary: Jupyter Kernels for the Spyder console
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/spyder-kernels/
Vcs: https://github.com/spyder-ide/spyder-kernels

BuildArch: noarch

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra test
BuildRequires: xvfb-run
BuildRequires: python3-module-pandas-tests
%endif

%description
Package that provides Jupyter kernels for use with the consoles of Spyder,
the Scientific Python Development Environment.

These kernels can launched either through Spyder itself or in an independent
Python session, and allow for interactive or file-based execution of Python
code inside Spyder.

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run -- xvfb-run -- pytest -vra

%files
%doc AUTHORS.txt CHANGELOG.md LICENSE.txt README.md
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
